﻿DROP   TABLE IF EXISTS log_postgresql_a_analyser;
CREATE  TABLE log_postgresql_a_analyser
        (date_heure_log TIMESTAMP(3) WITH TIME ZONE,utilisateur TEXT,base_de_donnees TEXT,
        id_process INTEGER,connection_from TEXT,id_session TEXT,num_ligne_session BIGINT,
        indicatif_commande TEXT,date_heure_debut_session TIMESTAMP WITH TIME ZONE,
        id_transaction_virtuelle TEXT,id_transaction BIGINT,severite_erreur TEXT,code_etat_sql TEXT,
        message TEXT,detail TEXT,hint TEXT,requete_interne TEXT,pos_requete_interne INTEGER,
        contexte TEXT,requete TEXT,pos_requete INTEGER,localisation TEXT,nom_application TEXT,
        PRIMARY KEY (id_session, num_ligne_session));
COPY    log_postgresql_a_analyser FROM 'C:/Users/jmsou/log_postgresql1.csv' WITH csv;
WITH    recup_info_log(utilisateur,base_de_donnees,requete,duree_ms) AS
(SELECT utilisateur,base_de_donnees,
        SUBSTR(message,POSITION('ms, instruction : ' IN message)+18) AS requete,
        CAST(REPLACE(SUBSTR(message,9,POSITION (' ms,' IN message) -9),'.','') AS BIGINT)
 FROM   log_postgresql_a_analyser
 WHERE  indicatif_commande='SELECT')
SELECT  base_de_donnees,utilisateur,requete,
        SUM(duree_ms) AS duree_cumulee_exec_requete,
        COUNT(*) AS frequence_exec_requete
 FROM   recup_info_log
 GROUP  BY base_de_donnees,utilisateur,requete
 HAVING SUM(duree_ms) != 0
 ORDER  BY base_de_donnees,SUM(duree_ms) DESC; 